/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.msgpack.rpc.server.RPCServerPipelineFactory;
import org.msgpack.rpc.server.Server;

public class UDPServer
extends Server {
    protected final InetSocketAddress addr;
    protected final ConnectionlessBootstrap bootstrap;
    protected final DatagramChannelFactory factory;
    protected Channel ch;

    public UDPServer(String host, int port, Object userHandler) {
        this(new InetSocketAddress(host, port), userHandler);
    }

    public UDPServer(InetSocketAddress addr, Object userHandler) {
        this.addr = addr;
        this.factory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        this.bootstrap = new ConnectionlessBootstrap((ChannelFactory)this.factory);
        this.bootstrap.setOption("receiveBufferSize", (Object)65536);
        this.bootstrap.setOption("broadcast", (Object)"false");
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new RPCServerPipelineFactory(userHandler, false));
    }

    public synchronized void serv() throws IOException {
        this.ch = this.bootstrap.bind((SocketAddress)this.addr);
    }

    public synchronized void stop() {
        if (this.ch != null) {
            this.ch.close().awaitUninterruptibly();
        }
        this.factory.releaseExternalResources();
    }
}

