/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client.transport;

import org.msgpack.rpc.client.EventLoop;
import org.msgpack.rpc.client.Session;
import org.msgpack.rpc.client.transport.Transport;
import org.msgpack.rpc.client.transport.UDPSocket;

public class UDPTransport
extends Transport {
    protected final UDPSocket socket;

    public UDPTransport(Session session, EventLoop loop) {
        super(session, loop);
        this.socket = new UDPSocket(session.getAddress(), loop, this);
    }

    public void sendMessage(Object msg) throws Exception {
        this.socket.trySend(msg);
    }

    public void tryClose() {
        this.socket.tryClose();
    }

    public void onConnected() throws Exception {
        throw new Exception("shoud not be called");
    }

    public void onMessageReceived(Object replyObject) throws Exception {
        this.session.onMessageReceived(replyObject);
    }

    public void onConnectFailed() throws Exception {
        throw new Exception("shoud not be called");
    }

    public void onClosed() {
        this.tryClose();
        this.session.onClosed();
    }

    public void onFailed(Exception e) {
        this.tryClose();
        this.session.onFailed(e);
    }
}

