/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.msgpack.rpc.client.Address;
import org.msgpack.rpc.client.EventLoop;
import org.msgpack.rpc.client.transport.TCPClientPipelineFactory;
import org.msgpack.rpc.client.transport.TCPTransport;

public class TCPSocket {
    protected final Address address;
    protected final EventLoop loop;
    protected final TCPTransport transport;
    protected ClientBootstrap bootstrap;
    protected ChannelFuture connectFuture;
    protected Channel channel;

    public TCPSocket(Address address, EventLoop loop, TCPTransport transport) {
        this.address = address;
        this.loop = loop;
        this.transport = transport;
        this.connectFuture = null;
        this.channel = null;
        this.bootstrap = loop.createSocketBootstrap();
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new TCPClientPipelineFactory(this));
    }

    protected synchronized void tryConnect() throws Exception {
        if (this.connectFuture != null) {
            throw new IOException("already connected");
        }
        this.connectFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.address.getHost(), this.address.getPort()));
    }

    public synchronized void trySend(Object msg) throws Exception {
        if (this.connectFuture == null || this.channel == null) {
            throw new IOException("not connected, but try send");
        }
        this.channel.write(msg);
    }

    public synchronized void tryClose() {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close().awaitUninterruptibly();
        }
        this.connectFuture = null;
        this.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() throws Exception {
        boolean isSuccess = false;
        TCPSocket tCPSocket = this;
        synchronized (tCPSocket) {
            if (this.channel != null) {
                throw new IOException("already connected");
            }
            if (this.connectFuture == null) {
                throw new IOException("tryConnect was not called");
            }
            this.channel = this.connectFuture.awaitUninterruptibly().getChannel();
            isSuccess = this.connectFuture.isSuccess();
        }
        if (isSuccess) {
            this.transport.onConnected();
        } else {
            this.onConnectFailed();
        }
    }

    public void onConnectFailed() {
        this.transport.onConnectFailed();
        this.tryClose();
    }

    public void onMessageReceived(Object replyObject) throws Exception {
        this.transport.onMessageReceived(replyObject);
    }

    public void onClosed() {
        this.transport.onClosed();
        this.tryClose();
    }

    public void onFailed(Exception e) {
        this.transport.onFailed(e);
        this.tryClose();
    }
}

