/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client;

import java.io.IOException;

public class Future {
    protected Exception error = null;
    protected Object result = null;
    protected boolean isFinished = false;
    protected boolean isJoined = false;
    protected long expireMills;
    protected boolean isTimeouted;

    public Future(double timeoutSec) {
        this.expireMills = System.currentTimeMillis() + (long)(timeoutSec * 1000.0);
        this.isTimeouted = false;
    }

    public synchronized void join() {
        try {
            while (!this.isFinished) {
                long curMills = System.currentTimeMillis();
                if (curMills >= this.expireMills) {
                    this.isTimeouted = true;
                    throw new IOException("timeout occurred");
                }
                this.wait(this.expireMills - curMills);
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
        this.isJoined = true;
    }

    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    public void setResult(Object result) {
        this.set(null, result);
    }

    public void setError(Object error) {
        Exception e = error instanceof String ? new IOException((String)error) : (error instanceof Exception ? (Exception)error : new IOException("Unknown Error"));
        this.set(e, null);
    }

    protected synchronized void set(Exception error, Object result) {
        if (this.isTimeouted) {
            return;
        }
        this.isFinished = true;
        this.error = error;
        this.result = result;
        this.notifyAll();
    }

    public synchronized Object getResult() throws Exception {
        if (!this.isJoined) {
            throw new IOException("Calling getResult() without join()");
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }
}

