/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.msgpack.rpc.server.RPCServerPipelineFactory;
import org.msgpack.rpc.server.Server;

public class TCPServer
extends Server {
    protected final InetSocketAddress addr;
    protected final ServerBootstrap bootstrap;
    protected final ChannelFactory factory;
    protected Channel ch;

    public TCPServer(String host, int port, Object userHandler) {
        this(new InetSocketAddress(host, port), userHandler);
    }

    public TCPServer(InetSocketAddress addr, Object userHandler) {
        this.addr = addr;
        this.factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.bootstrap = new ServerBootstrap(this.factory);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new RPCServerPipelineFactory(userHandler, true));
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
    }

    public synchronized void serv() throws IOException {
        this.ch = this.bootstrap.bind((SocketAddress)this.addr);
    }

    public synchronized void stop() {
        if (this.ch != null) {
            this.ch.close().awaitUninterruptibly();
        }
        this.factory.releaseExternalResources();
    }
}

