/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.server;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.channels.Channel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCServerHandler
extends SimpleChannelHandler {
    protected Object handler = null;
    protected Method[] handlerMethods = null;

    public RPCServerHandler(Object handler) {
        this.handler = handler;
        this.handlerMethods = handler.getClass().getMethods();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent ev) {
        ev.getCause().printStackTrace();
        Channel ch = (Channel)ev.getChannel();
        try {
            ch.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object obj = e.getMessage();
        if (obj == null) {
            return;
        }
        List list = (List)obj;
        for (Object o : list) {
            this.processOneMessage(e, o);
        }
    }

    protected void processOneMessage(MessageEvent e, Object o) throws Exception {
        AbstractList a = (AbstractList)o;
        if (a.size() != 4) {
            throw new IOException("Invalid MPRPC");
        }
        Object type = a.get(0);
        Object msgid = a.get(1);
        Object method = a.get(2);
        Object params = a.get(3);
        if (((Number)type).intValue() != 0) {
            throw new IOException("Invalid MPRPC");
        }
        if (!(method instanceof byte[])) {
            throw new IOException("Invalid method");
        }
        Object handlerResult = null;
        String errorMessage = null;
        try {
            ArrayList paramList = params instanceof AbstractList ? (ArrayList)params : new ArrayList();
            handlerResult = this.callMethod(this.handler, new String((byte[])method), paramList);
        }
        catch (Exception rpc_e) {
            errorMessage = rpc_e.getMessage();
        }
        ArrayList<Object> response = new ArrayList<Object>();
        response.add(1);
        response.add(msgid);
        response.add(errorMessage);
        response.add(handlerResult);
        e.getChannel().write(response, e.getRemoteAddress());
    }

    protected Object callMethod(Object handler, String method, AbstractList<?> params) throws Exception {
        Method m = this.findMethod(handler, method, params);
        if (m == null) {
            throw new IOException("No such method");
        }
        return m.invoke(handler, params.toArray());
    }

    protected Method findMethod(Object handler, String method, AbstractList<?> params) {
        int nParams = params.size();
        Method[] ms = this.handlerMethods;
        int i = 0;
        while (i < ms.length) {
            Method m = ms[i];
            if (method.equals(m.getName()) && nParams == m.getParameterTypes().length) {
                return m;
            }
            ++i;
        }
        return null;
    }
}

