/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.server;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.msgpack.Unpacker;

public class RPCRequestDecoder
extends FrameDecoder {
    protected final boolean isStream;
    protected Unpacker unpacker;

    public RPCRequestDecoder(boolean isStream) {
        this.isStream = isStream;
        this.unpacker = new Unpacker();
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int len = buffer.readableBytes();
        if (len == 0) {
            return null;
        }
        if (!this.isStream) {
            this.unpacker.reset();
        }
        this.unpacker.reserveBuffer(len);
        byte[] unpacker_buf = this.unpacker.getBuffer();
        buffer.readBytes(unpacker_buf, this.unpacker.getBufferOffset(), len);
        this.unpacker.bufferConsumed(len);
        ArrayList<Object> ret = new ArrayList<Object>();
        while (this.unpacker.execute()) {
            Object data = this.unpacker.getData();
            this.unpacker.reset();
            if (data instanceof AbstractList) {
                ret.add(data);
                continue;
            }
            throw new IOException("invalid MPRPC" + data);
        }
        return ret;
    }
}

