/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.msgpack.rpc.client.Address;
import org.msgpack.rpc.client.EventLoop;
import org.msgpack.rpc.client.transport.UDPClientPipelineFactory;
import org.msgpack.rpc.client.transport.UDPTransport;

public class UDPSocket {
    protected final Address address;
    protected final EventLoop loop;
    protected final UDPTransport transport;
    protected ConnectionlessBootstrap bootstrap;
    protected DatagramChannel channel;

    public UDPSocket(Address address, EventLoop loop, UDPTransport transport) {
        this.address = address;
        this.loop = loop;
        this.transport = transport;
        this.bootstrap = loop.createDatagramBootstrap();
        this.bootstrap.setOption("broadcast", (Object)"false");
        this.bootstrap.setOption("sendBufferSize", (Object)65536);
        this.bootstrap.setOption("receiveBufferSize", (Object)65536);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new UDPClientPipelineFactory(this));
        this.channel = null;
    }

    public synchronized void trySend(Object msg) throws Exception {
        if (this.channel == null) {
            this.channel = (DatagramChannel)this.bootstrap.bind((SocketAddress)new InetSocketAddress(0));
        }
        this.channel.write(msg, (SocketAddress)new InetSocketAddress(this.address.getHost(), this.address.getPort()));
    }

    public synchronized void tryClose() {
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
        }
        this.channel = null;
    }

    public void onMessageReceived(Object replyObject) throws Exception {
        this.transport.onMessageReceived(replyObject);
    }

    public void onFailed(Exception e) {
        this.transport.onFailed(e);
    }
}

