/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client.transport;

import java.util.ArrayList;
import java.util.List;
import org.msgpack.rpc.client.EventLoop;
import org.msgpack.rpc.client.Session;
import org.msgpack.rpc.client.transport.TCPSocket;
import org.msgpack.rpc.client.transport.Transport;

public class TCPTransport
extends Transport {
    protected final TCPSocket socket;
    protected Boolean isConnecting = false;
    protected Boolean isConnected = false;
    protected List<Object> pendingMessages;

    public TCPTransport(Session session, EventLoop loop) {
        super(session, loop);
        this.socket = new TCPSocket(session.getAddress(), loop, this);
        this.pendingMessages = new ArrayList<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Object msg) throws Exception {
        boolean isTryConnect = false;
        boolean isTrySend = false;
        TCPTransport tCPTransport = this;
        synchronized (tCPTransport) {
            if (this.isConnected.booleanValue()) {
                isTrySend = true;
            } else {
                if (!this.isConnecting.booleanValue()) {
                    isTryConnect = true;
                    this.isConnecting = true;
                }
                this.pendingMessages.add(msg);
            }
        }
        if (isTryConnect) {
            this.socket.tryConnect();
        }
        if (isTrySend) {
            this.socket.trySend(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryClose() {
        TCPTransport tCPTransport = this;
        synchronized (tCPTransport) {
            this.isConnecting = false;
            this.isConnected = false;
            this.pendingMessages.clear();
        }
        this.socket.tryClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() throws Exception {
        Object[] msgs;
        TCPTransport tCPTransport = this;
        synchronized (tCPTransport) {
            this.isConnecting = false;
            this.isConnected = true;
            msgs = this.pendingMessages.toArray();
            this.pendingMessages.clear();
        }
        for (Object msg : msgs) {
            this.socket.trySend(msg);
        }
    }

    public void onMessageReceived(Object replyObjects) throws Exception {
        this.session.onMessageReceived(replyObjects);
    }

    public void onConnectFailed() {
        this.tryClose();
        this.session.onConnectFailed();
    }

    public void onClosed() {
        this.tryClose();
        this.session.onClosed();
    }

    public void onFailed(Exception e) {
        this.tryClose();
        this.session.onFailed(e);
    }
}

