/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client.transport;

import java.io.IOException;
import java.net.ConnectException;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.msgpack.rpc.client.RPCException;
import org.msgpack.rpc.client.transport.TCPSocket;

class TCPClientHandler
extends SimpleChannelHandler {
    protected final TCPSocket sock;

    public TCPClientHandler(TCPSocket sock) {
        this.sock = sock;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent ev) {
        try {
            this.sock.onConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sock.onConnectFailed();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent ev) {
        try {
            this.sock.onMessageReceived(ev.getMessage());
        }
        catch (RPCException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sock.onFailed(e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent ev) {
        Throwable e = ev.getCause();
        if (e instanceof ConnectException) {
            this.sock.onConnectFailed();
        } else if (e instanceof RPCException) {
            e.printStackTrace();
        } else {
            this.sock.onFailed(new IOException(e.getMessage()));
        }
    }
}

