/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.msgpack.rpc.Constants;
import org.msgpack.rpc.client.Address;
import org.msgpack.rpc.client.EventLoop;
import org.msgpack.rpc.client.Future;
import org.msgpack.rpc.client.RPCException;
import org.msgpack.rpc.client.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session {
    protected final Address addr;
    protected final EventLoop loop;
    protected HashMap<Integer, Future> reqTable;
    protected Transport transport;
    static int msgidCounter = 0;
    protected double timeoutSec;
    protected ScheduledFuture<?> timeoutCheckTimer;

    public Session(Address addr, EventLoop loop) {
        this.addr = addr;
        this.loop = loop;
        this.reqTable = new HashMap();
        this.transport = null;
        this.timeoutSec = Constants.DEFAULT_TIMEOUT_SEC;
        this.timeoutCheckTimer = null;
    }

    protected abstract Transport getTransport();

    public Address getAddress() {
        return this.addr;
    }

    public synchronized void setTimeoutSec(double timeoutSec) {
        this.timeoutSec = timeoutSec;
    }

    public synchronized double getTimeoutSec() {
        return this.timeoutSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future sendRequest(String method, Object[] args) {
        int msgid;
        Future future = new Future(this.getTimeoutSec());
        Session session = this;
        synchronized (session) {
            if (this.timeoutCheckTimer == null) {
                TimeoutCheckTask task = new TimeoutCheckTask(this);
                this.timeoutCheckTimer = this.loop.registerTimer(task, 1);
            }
            msgid = this.generateMessageID();
            this.reqTable.put(msgid, future);
        }
        try {
            ArrayList<Object> request = this.createRPCMessage(0, msgid, method, args);
            this.getTransport().sendMessage(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            future.setError(e);
        }
        return future;
    }

    private int generateMessageID() {
        int msgid;
        if ((msgid = msgidCounter++) > 0x40000000) {
            msgidCounter = 0;
        }
        return msgid;
    }

    private ArrayList<Object> createRPCMessage(int type, int msgid, String method, Object[] args) {
        ArrayList<Object> message = new ArrayList<Object>();
        message.add(0);
        message.add(msgid);
        message.add(method);
        ArrayList<Object> params = new ArrayList<Object>();
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                params.add(o);
                ++n2;
            }
        }
        message.add(params);
        return message;
    }

    protected synchronized void tryClose() {
        for (Map.Entry<Integer, Future> ent : this.reqTable.entrySet()) {
            Future f = ent.getValue();
            f.setError("Connection Closed");
        }
        this.reqTable.clear();
        if (this.transport != null) {
            this.transport.tryClose();
        }
        this.transport = null;
        if (this.timeoutCheckTimer != null) {
            this.timeoutCheckTimer.cancel(true);
        }
        this.timeoutCheckTimer = null;
    }

    public synchronized void checkTimeout() {
        Set<Map.Entry<Integer, Future>> entries = this.reqTable.entrySet();
        for (Map.Entry<Integer, Future> e : entries) {
            int msgid = e.getKey();
            Future f = e.getValue();
            if (f == null || !f.isFinished()) continue;
            this.reqTable.remove(msgid);
        }
    }

    public void onMessageReceived(Object replyObjects) throws Exception {
        if (replyObjects == null) {
            return;
        }
        if (!(replyObjects instanceof AbstractList)) {
            throw new RPCException("invalid decoder");
        }
        List lists = (List)replyObjects;
        for (Object o : lists) {
            this.onMessageReceivedOne(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageReceivedOne(Object replyObject) throws Exception {
        Future future;
        if (!(replyObject instanceof AbstractList)) {
            throw new RPCException("invalid MPRPC Response");
        }
        AbstractList a = (AbstractList)replyObject;
        if (a.size() != 4) {
            throw new RPCException("invalid MPRPC Protocol");
        }
        Object objType = a.get(0);
        Object objMsgID = a.get(1);
        Object objError = a.get(2);
        Object objResult = a.get(3);
        if (!(objMsgID instanceof Number)) {
            throw new RPCException("invalid msgid");
        }
        int msgid = ((Number)objMsgID).intValue();
        Session session = this;
        synchronized (session) {
            if (!this.reqTable.containsKey(msgid)) {
                throw new RPCException("not my msgid: msgid=" + msgid);
            }
            future = this.reqTable.get(msgid);
            this.reqTable.remove(msgid);
        }
        try {
            int type = ((Number)objType).intValue();
            if (type != 1) {
                future.setError("Invalid MPRPC Response Type");
                return;
            }
            if (objError != null) {
                String errorString = "Error";
                if (objError instanceof byte[]) {
                    errorString = new String((byte[])objError);
                }
                future.setError(errorString);
                return;
            }
            future.setResult(objResult);
        }
        catch (Exception e) {
            future.setError(e);
        }
    }

    public synchronized void onConnectFailed() {
        for (Map.Entry<Integer, Future> ent : this.reqTable.entrySet()) {
            Future f = ent.getValue();
            f.setError("Connect Failed");
        }
        this.reqTable.clear();
        this.tryClose();
    }

    public synchronized void onClosed() {
        this.tryClose();
    }

    public synchronized void onFailed(Exception e) {
        for (Map.Entry<Integer, Future> ent : this.reqTable.entrySet()) {
            Future f = ent.getValue();
            f.setError(e);
        }
        this.reqTable.clear();
        this.tryClose();
    }

    class TimeoutCheckTask
    implements Runnable {
        protected final Session session;

        public TimeoutCheckTask(Session session2) {
            this.session = session2;
        }

        public void run() {
            this.session.checkTimeout();
        }
    }
}

