/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.rpc.client;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventLoop {
    protected final ExecutorService bossService = Executors.newCachedThreadPool();
    protected final ExecutorService workerService = Executors.newCachedThreadPool();
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public ClientBootstrap createSocketBootstrap() {
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory((Executor)this.bossService, (Executor)this.workerService);
        return new ClientBootstrap((ChannelFactory)factory);
    }

    public ConnectionlessBootstrap createDatagramBootstrap() {
        NioDatagramChannelFactory factory = new NioDatagramChannelFactory((Executor)this.bossService);
        return new ConnectionlessBootstrap((ChannelFactory)factory);
    }

    public ScheduledFuture<?> registerTimer(Runnable task, int intervalSec) {
        return this.scheduler.scheduleAtFixedRate(task, 0L, intervalSec * 1000, TimeUnit.MILLISECONDS);
    }

    public synchronized void shutdown() {
        this.bossService.shutdown();
        this.workerService.shutdown();
        this.scheduler.shutdown();
    }
}

